import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  if(body.messageID) {
    const res: any = await event.context.fetch('models/ad_usermail', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      AD_User_ID: {
        id: body.userId,
        tableName: 'AD_User'
      },
      messageID: body.messageID,
      subject: body.subject,
      mailText: body.mailText,
      isDelivered: {
        id: body.isDeliveredId || 'N'
      },
      isActive: body.isActive,
      tableName: 'AD_Usermail'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})